/*
 * Decompiled with CFR 0.152.
 */
package com.mursaat.extendedtextview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.mursaat.extendedtextview.CustomFontManager;
import com.mursaat.extendedtextview.GradientManager;

public class AnimatedGradientTextView
extends TextView {
    GradientManager gradientManager;

    public AnimatedGradientTextView(Context context) {
        super(context);
        this.gradientManager = new GradientManager(this);
    }

    public AnimatedGradientTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.gradientManager = new GradientManager(this, attrs);
        CustomFontManager.applyFontFromAttrs(this, attrs);
    }

    public AnimatedGradientTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.gradientManager = new GradientManager(this, attrs);
        CustomFontManager.applyFontFromAttrs(this, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.gradientManager.stopGradient();
        this.gradientManager.startGradient();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            if (this.getScaleX() != 0.0f && this.getScaleY() != 0.0f) {
                this.gradientManager.startGradient();
            }
        } else {
            this.gradientManager.stopGradient();
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            if (this.getScaleX() != 0.0f && this.getScaleY() != 0.0f) {
                this.gradientManager.startGradient();
            }
        } else {
            this.gradientManager.stopGradient();
        }
    }

    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        if (screenState == 0) {
            this.gradientManager.stopGradient();
        } else if (screenState == 1) {
            this.gradientManager.startGradient();
        }
    }
}

