/*
 * Decompiled with CFR 0.152.
 */
package com.mursaat.extendedtextview;

import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import com.mursaat.extendedtextview.GradientRunnable;
import com.mursaat.extendedtextview.R;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class GradientManager {
    private final TextView textView;
    private int[] colors;
    private int simultaneousColors;
    private int angle;
    private int speed;
    private int maxFPS;
    private int drawTimeInterval;
    private GradientRunnable runnable;
    private ScheduledFuture<?> scheduledFuture = null;
    private long currentGradientProgress = 0L;
    private static final int ATTR_NOT_FOUND = Integer.MIN_VALUE;

    public GradientManager(TextView textView) {
        this.textView = textView;
        this.initDefaultValues();
    }

    public GradientManager(TextView textView, AttributeSet attrs) {
        this.textView = textView;
        this.initFromAttrsValues(attrs);
    }

    private void initFromAttrsValues(AttributeSet attrs) {
        int[] set = new int[]{R.attr.colors, R.attr.simultaneousColors, R.attr.angle, R.attr.speed, R.attr.maxFPS};
        TypedArray typedArray = this.textView.getContext().obtainStyledAttributes(attrs, set);
        int colorsArrayId = typedArray.getResourceId(0, Integer.MIN_VALUE);
        this.colors = colorsArrayId != Integer.MIN_VALUE ? this.textView.getResources().getIntArray(colorsArrayId) : this.textView.getResources().getIntArray(R.array.default_gradient_colors);
        this.simultaneousColors = typedArray.getInt(1, Integer.MIN_VALUE);
        this.angle = typedArray.getInt(2, Integer.MIN_VALUE);
        this.speed = typedArray.getInt(3, Integer.MIN_VALUE);
        this.maxFPS = typedArray.getInt(4, Integer.MIN_VALUE);
        if (this.simultaneousColors == Integer.MIN_VALUE) {
            this.simultaneousColors = 2;
        }
        if (this.angle == Integer.MIN_VALUE) {
            this.angle = 45;
        }
        if (this.speed == Integer.MIN_VALUE) {
            this.speed = 1000;
        }
        if (this.maxFPS == Integer.MIN_VALUE) {
            this.maxFPS = 24;
        }
        this.drawTimeInterval = 1000 / this.maxFPS;
        typedArray.recycle();
    }

    private void initDefaultValues() {
        this.colors = new int[]{-16776961, -65536, -16711936};
        this.simultaneousColors = 2;
        this.angle = 45;
        this.speed = 2000;
        this.maxFPS = 24;
        this.drawTimeInterval = 1000 / this.maxFPS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGradient() {
        GradientManager gradientManager = this;
        synchronized (gradientManager) {
            if (this.scheduledFuture != null) {
                this.currentGradientProgress = this.runnable.getCurrentProgress();
                this.scheduledFuture.cancel(true);
                this.runnable = null;
                this.scheduledFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGradient() {
        GradientManager gradientManager = this;
        synchronized (gradientManager) {
            if (this.scheduledFuture != null) {
                return;
            }
            int wf = this.textView.getWidth();
            int hf = this.textView.getHeight();
            if (wf > 0 && hf > 0) {
                this.runnable = new GradientRunnable(this.textView, this.colors, this.simultaneousColors, this.angle, this.speed);
                this.runnable.setCurrentProgress(this.currentGradientProgress);
                ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
                this.scheduledFuture = scheduledExecutor.scheduleAtFixedRate(this.runnable, 0L, this.drawTimeInterval, TimeUnit.MILLISECONDS);
            }
        }
    }
}

