/*
 * Decompiled with CFR 0.152.
 */
package com.mursaat.extendedtextview;

import android.animation.ArgbEvaluator;
import android.graphics.LinearGradient;
import android.graphics.Point;
import android.graphics.Shader;
import android.os.SystemClock;
import android.widget.TextView;
import com.mursaat.extendedtextview.MathsUtils;
import java.util.Arrays;

public class GradientRunnable
implements Runnable {
    private final TextView textView;
    private int[] colors;
    private int angle;
    private int speed;
    private long totalDelta = 0L;
    private long lastTime = 0L;
    private int[] currentColors;
    private Point[] gradientsPositions;
    private int currentGradient = 0;

    GradientRunnable(TextView textView, int[] colors, int simultaneousColors, int angle, int speed) {
        this.textView = textView;
        this.colors = colors;
        this.angle = angle;
        this.speed = speed;
        int wf = textView.getWidth();
        int hf = textView.getHeight();
        this.gradientsPositions = this.getGradientsPoints(wf, hf);
        this.currentColors = Arrays.copyOf(colors, simultaneousColors);
    }

    @Override
    public void run() {
        long currentTime = SystemClock.uptimeMillis();
        long delta = currentTime - this.lastTime;
        this.totalDelta += delta;
        float totalPercentage = (float)this.totalDelta / (float)this.speed;
        totalPercentage = totalPercentage > 1.0f ? 1.0f : totalPercentage;
        for (int colorIndex = 0; colorIndex < this.currentColors.length; ++colorIndex) {
            this.currentColors[colorIndex] = (Integer)new ArgbEvaluator().evaluate(totalPercentage, (Object)this.colors[(this.currentGradient + colorIndex) % this.colors.length], (Object)this.colors[(this.currentGradient + (colorIndex + 1)) % this.colors.length]);
        }
        if (totalPercentage == 1.0f) {
            this.totalDelta = 0L;
            this.currentGradient = (this.currentGradient + 1) % this.colors.length;
        }
        LinearGradient shader = new LinearGradient((float)this.gradientsPositions[0].x, (float)this.gradientsPositions[0].y, (float)this.gradientsPositions[1].x, (float)this.gradientsPositions[1].y, this.currentColors, null, Shader.TileMode.CLAMP);
        this.textView.getPaint().setShader((Shader)shader);
        this.textView.postInvalidate();
        this.lastTime = currentTime;
    }

    private Point[] getGradientsPoints(int width, int height) {
        double angleRadian = Math.toRadians(this.angle);
        int circleRadius = width;
        Point circleCenter = new Point(width / 2, height / 2);
        Point secantP1 = new Point((int)((double)circleCenter.x - (double)circleRadius * Math.cos(angleRadian)), (int)((double)circleCenter.y - (double)circleRadius * Math.sin(angleRadian)));
        Point secantP2 = new Point((int)((double)circleCenter.x + (double)circleRadius * Math.cos(angleRadian)), (int)((double)circleCenter.y + (double)circleRadius * Math.sin(angleRadian)));
        Point[] intersectPoints = new Point[2];
        Point topSegmentP1 = new Point(0, 0);
        Point topSegmentP2 = new Point(width, 0);
        intersectPoints[0] = MathsUtils.getIntersectionPoint(secantP1, secantP2, topSegmentP1, topSegmentP2);
        if (intersectPoints[0] == null) {
            Point leftSegmentP1 = new Point(0, 0);
            Point leftSegmentP2 = new Point(0, height);
            intersectPoints[0] = MathsUtils.getIntersectionPoint(secantP1, secantP2, leftSegmentP1, leftSegmentP2);
        }
        Point bottomSegmentP1 = new Point(0, height);
        Point bottomSegmentP2 = new Point(width, height);
        intersectPoints[1] = MathsUtils.getIntersectionPoint(secantP1, secantP2, bottomSegmentP1, bottomSegmentP2);
        if (intersectPoints[1] == null) {
            Point rightSegmentP1 = new Point(width, 0);
            Point rightSegmentP2 = new Point(width, height);
            intersectPoints[1] = MathsUtils.getIntersectionPoint(secantP1, secantP2, rightSegmentP1, rightSegmentP2);
        }
        return intersectPoints;
    }

    public long getCurrentProgress() {
        return this.totalDelta;
    }

    public void setCurrentProgress(long progress) {
        this.totalDelta = progress;
    }
}

